<?php

$start_head_script = get_field('start_head',CONST_CUSTOM_PAGE_ID);
$end_head_script = get_field('end_head',CONST_CUSTOM_PAGE_ID);
$start_body_script = get_field('start_body',CONST_CUSTOM_PAGE_ID);

$currentPageID = get_the_ID();

$siteURL = home_URL();

$seoTitle = get_field('seo_page_title',$currentPageID);
$seoKeywords = get_field('seo_page_keywords',$currentPageID);
$seoDescription = get_field('seo_page_description',$currentPageID);
$seoImage = get_field('seo_page_image',$currentPageID);


if(is_404()){
	$siteURL = home_URL();
	wp_redirect($siteURL);
	exit(0);
}

?>

<!DOCTYPE html>
<html lang="en" class="no-js">
  <head>
    <?php echo $start_head_script; ?>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">     
    <title><?= $seoTitle; ?></title>
    <meta name="keywords" content="<?= $seoKeywords; ?>">
    <meta name="description" content="<?= $seoDescription; ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <meta name="author" content="lmpixels" />
    <link rel="shortcut icon" href="favicon.ico">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/reset.css" type="text/css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/bootstrap-grid.min.css" type="text/css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/animations.css" type="text/css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/perfect-scrollbar.css" type="text/css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/owl.carousel.css" type="text/css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/magnific-popup.css" type="text/css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/assets/css/main.css" type="text/css">
    <?php
      if(is_singular( 'post' )){
    ?>
        <script src="<?php echo get_template_directory_uri(); ?>/assets/js/modernizr.custom.js"></script>
    <?php
      }
    ?>
    <style>
      .form-group {
          margin: 0 0 30px;
      }
      .form-group .help-block {
          top: -25px;
          font-size: 0.73em;
          right: 0;
      }
      .form-group .help-block:after{        
        right: 5px;
        top: 100%;
        bottom:auto;
        left:auto;   
        border-top: 10px solid #ff4e4e;
        border-right: 10px solid transparent;
        border-bottom: none;
        border-left: none;
      }
    </style>
    <?php echo $end_head_script; ?>
	
  </head>

  <body>
    <?php echo $start_body_script; ?>
