<?php

define('CONST_CUSTOM_PAGE_ID', 6);
define('CONST_ABOUT_PAGE_ID', 94);
define('CONST_RESUME_PAGE_ID', 95);
define('CONST_PORTFOLIO_PAGE_ID', 133);
define('CONST_BLOG_PAGE_ID', 135);
define('CONST_CONTACT_PAGE_ID', 6);
define('CONST_DIRECTORY_PATH', get_template_directory_uri());
define('CONST_CSS_VERSION', date("YmdHim"));
define('ALLOW_UNFILTERED_UPLOADS', true );
define('CONST_PRIVACY_POLICY_PAGE_ID', 3);

function my_custom_login_logo() {
    echo '<style type="text/css">
        h1 a { 
        background-image:url('.get_bloginfo('template_directory').'/assets/img/logo.svg) !important;
        background-size:50% !important;
		background-position:center center !important;
		width:100% !important;
		height:200px !important;
		background-color:#fff !important;
     }
     
    </style>';
}
add_action('login_head', 'my_custom_login_logo');
// Disable Admin Bar for everyone
if (!function_exists('df_disable_admin_bar')) {
	function df_disable_admin_bar() {
		
		// for the admin page
		remove_action('admin_footer', 'wp_admin_bar_render', 1000);
		// for the front-end
		remove_action('wp_footer', 'wp_admin_bar_render', 1000);
	  	
		// css override for the admin page
		function remove_admin_bar_style_backend() { 
			echo '<style>body.admin-bar #wpcontent, body.admin-bar #adminmenu 
			{ padding-top: 0px !important; }</style>';
		}	  
		add_filter('admin_head','remove_admin_bar_style_backend');
		
		// css override for the frontend
		function remove_admin_bar_style_frontend() {
			echo '<style type="text/css" media="screen">
			html { margin-top: 0px !important; }
			* html body { margin-top: 0px !important; }
			</style>';
		}
		add_filter('wp_head','remove_admin_bar_style_frontend', 99);
  	}
}
//add_action('init','df_disable_admin_bar');
add_action('admin_menu','wphidenag');
function wphidenag() {
remove_action( 'admin_notices', 'update_nag', 3 );
}
// CUSTOMIZE ADMIN MENU ORDER
function custom_menu_order($menu_ord) {
   if (!$menu_ord) return true;
   return array(
	'index.php', // this represents the dashboard link
	'edit.php', //the posts tab
	'upload.php', // the media manager
	'edit.php?post_type=page', //the posts tab
);
}
add_filter('custom_menu_order', 'custom_menu_order');
add_filter('menu_order', 'custom_menu_order');

add_action( 'admin_bar_menu', 'toolbar_link_to_home', 999 );
function toolbar_link_to_home( $wp_admin_bar ) {
	$args = array(
					'id'    => 'myportfolio_nav_main',
					'title' => 'Main Navigation',
					'href'  => home_url('/wp-admin/nav-menus.php'),
					'meta'  => array( 'class' => 'myportfolio_nav_main' )
	);
	$wp_admin_bar->add_node( $args );		
	$args = array(
					'id'    => 'myportfolio_site',
					'title' => 'Global Settings',
					'href'  => home_url('/wp-admin/post.php?post=6&action=edit'),
					'meta'  => array( 'class' => 'myportfolio_site' )
	);
	$wp_admin_bar->add_node( $args );
  $args = array(
          'id'    => 'myportfolio_homepage',
          'title' => 'Home Page',
          'href'  => home_url('/wp-admin/post.php?post=39&action=edit'),
          'meta'  => array( 'class' => 'myportfolio_homepage' )
  );
  $wp_admin_bar->add_node( $args );

}

function custom_loginlogo_url($url) {
	return home_url();
}
add_filter( 'login_headerurl', 'custom_loginlogo_url' );

add_action('admin_head', 'my_custom_css');
function my_custom_css() {
  $current_user = wp_get_current_user();

  if ( !($current_user->user_login == 'editor') ){
    echo  '<style>
      #post-44, #toplevel_page_wps_{
        display:none !important;
      }   
      </style>';    
  }else{
      echo  '<style>
      #post-44{
        display:none !important;
      }   
      </style>';
  }

  echo  '<style>
    .hideItem{
      display:none !important;
    } 
    /*  
    .edit-post-meta-boxes-area #poststuff .stuffbox>h3,
    .edit-post-meta-boxes-area #poststuff h2.hndle, 
    .edit-post-meta-boxes-area #poststuff h3.hndle,
    #poststuff .stuffbox>h3, 
    #poststuff h2, 
    #poststuff h3.hndle{
      background-color: #f07f23 !important;
      color:#fff !important;
      text-transform: uppercase;
    }
    .wp-core-ui .button-primary-disabled, 
    .wp-core-ui .button-primary.disabled, 
    .wp-core-ui .button-primary:disabled, 
    .wp-core-ui .button-primary[disabled]{
      border-color: #bb7135 !important;
      background-color: #bb7135 !important;
      box-shadow: 0 1px 0 #fff !important;
      text-shadow: 0 -1px 1px #bb7135, 1px 0 1px #bb7135, 0 1px 1px #bb7135, -1px 0 1px #bb7135 !important;
    }
    .components-button.is-primary,
    .wp-core-ui .button-primary{
      border-color: #f07f23 !important;
      background-color: #f07f23 !important;
      box-shadow: 0 1px 0 #fff !important;
      text-shadow: 0 -1px 1px #f07f23, 1px 0 1px #f07f23, 0 1px 1px #f07f23, -1px 0 1px #f07f23 !important;
    }
    .edit-post-meta-boxes-area .postbox>.inside{
      background-color: #eeeeee !important;
    }
    #editor .postbox .handlediv .toggle-indicator,
    .acf-postbox>.hndle .acf-hndle-cog{
      color: #f6f4f4 !important;
    }
    .acf-postbox>.hndle .acf-hndle-cog:hover,
    .accordion-section-title:after, 
    .handlediv, .item-edit, 
    .postbox .handlediv.button-link, 
    .toggle-indicator{
      color: #fff !important;
    }
    #editor .postbox{
      margin-bottom:20px;
    }
    .acf-tab-group li a{
      border:none !important;
    }
    .acf-fields>.acf-tab-wrap .acf-tab-group li a{
      background-color: #eeeeee !important;
      color: #f07f23 !important; 
    }    
    .acf-fields>.acf-tab-wrap .acf-tab-group li:hover a,
    .acf-fields>.acf-tab-wrap .acf-tab-group li.active a{
      background-color: #ffb376 !important;      
      color: #fff !important;
    }

    #adminmenu li.current a.menu-top, 
    #adminmenu li.wp-has-current-submenu .wp-submenu .wp-submenu-head, 
    #adminmenu li.wp-has-current-submenu a.wp-has-current-submenu, 
    .folded #adminmenu li.current.menu-top,
    #adminmenu a:hover, 
    #adminmenu li.menu-top:hover, 
    #adminmenu li.opensub>a.menu-top, 
    #adminmenu li>a.menu-top:focus
    {
      background-color: #f07f23 !important;
    }

    .acf-field-object.open>.handle{
      background-color: #363b3f !important;
      border: #363b3f solid 1px !important;
      text-shadow: #363b3f 0 1px 0 !important;
    }

    #wpadminbar .ab-top-menu>li.menupop.hover>.ab-item, 
    #wpadminbar.nojq .quicklinks .ab-top-menu>li>.ab-item:focus, 
    #wpadminbar.nojs .ab-top-menu>li.menupop:hover>.ab-item, 
    #wpadminbar:not(.mobile) .ab-top-menu>li:hover>.ab-item, 
    #wpadminbar:not(.mobile) .ab-top-menu>li>.ab-item:focus{
      background-color: #f07f23 !important;
      color:#fff !important;
    }

    #wpadminbar .quicklinks .ab-sub-wrapper .menupop.hover>a, 
    #wpadminbar .quicklinks .menupop ul li a:focus, 
    #wpadminbar .quicklinks .menupop ul li a:focus strong, 
    #wpadminbar .quicklinks .menupop ul li a:hover, 
    #wpadminbar .quicklinks .menupop ul li a:hover strong, 
    #wpadminbar .quicklinks .menupop.hover ul li a:focus, 
    #wpadminbar .quicklinks .menupop.hover ul li a:hover, 
    #wpadminbar li #adminbarsearch.adminbar-focused:before, 
    #wpadminbar li .ab-item:focus .ab-icon:before, 
    #wpadminbar li .ab-item:focus:before, 
    #wpadminbar li a:focus .ab-icon:before, 
    #wpadminbar li.hover .ab-icon:before, 
    #wpadminbar li.hover .ab-item:before, 
    #wpadminbar li:hover #adminbarsearch:before, 
    #wpadminbar li:hover .ab-icon:before, 
    #wpadminbar li:hover .ab-item:before, 
    #wpadminbar.nojs .quicklinks .menupop:hover ul li a:focus, 
    #wpadminbar.nojs .quicklinks .menupop:hover ul li a:hover{
      background-color: #f07f23 !important;
      color:#fff !important;
    }

    #wpadminbar:not(.mobile)>#wp-toolbar a:focus span.ab-label, 
    #wpadminbar:not(.mobile)>#wp-toolbar li.hover span.ab-label, 
    #wpadminbar:not(.mobile)>#wp-toolbar li:hover span.ab-label{
      color:#fff !important;
    }

    #adminmenu .wp-has-current-submenu.opensub .wp-submenu li.current a:focus, 
    #adminmenu .wp-has-current-submenu.opensub .wp-submenu li.current a:hover, 
    #adminmenu .wp-submenu li.current a:focus, 
    #adminmenu .wp-submenu li.current a:hover, 
    #adminmenu a.wp-has-current-submenu:focus+.wp-submenu li.current a:focus, 
    #adminmenu a.wp-has-current-submenu:focus+.wp-submenu li.current a:hover,
    #adminmenu .wp-has-current-submenu .wp-submenu a:focus, 
    #adminmenu .wp-has-current-submenu .wp-submenu a:hover, 
    #adminmenu .wp-has-current-submenu.opensub .wp-submenu a:focus, 
    #adminmenu .wp-has-current-submenu.opensub .wp-submenu a:hover, 
    #adminmenu .wp-submenu a:focus, #adminmenu .wp-submenu a:hover, 
    #adminmenu a.wp-has-current-submenu:focus+.wp-submenu a:focus, 
    #adminmenu a.wp-has-current-submenu:focus+.wp-submenu a:hover, 
    .folded #adminmenu .wp-has-current-submenu .wp-submenu a:focus, 
    .folded #adminmenu .wp-has-current-submenu .wp-submenu a:hover{
      color:#fff !important;
    }

    #adminmenu li.menu-top:hover, 
    #adminmenu li.opensub>a.menu-top, 
    #adminmenu li>a.menu-top:focus,
    #adminmenu li a:focus div.wp-menu-image:before,
    #adminmenu li.opensub div.wp-menu-image:before,
    #adminmenu li:hover div.wp-menu-image:before{
      color:#fff !important;
    }
    #collapse-button:focus, #collapse-button:hover{
      color:#f07f23 !important;
    }
    */
    </style>';
}

function remove_admin_login_header() {
	remove_action('wp_head', '_admin_bar_bump_cb');
}
add_action('get_header', 'remove_admin_login_header');

function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

//add SVG to allowed file uploads
function add_file_types_to_uploads($file_types){

    $new_filetypes = array();
    $new_filetypes['svg'] = 'image/svg+xml';
    $file_types = array_merge($file_types, $new_filetypes );

    return $file_types;
}
add_action('upload_mimes', 'add_file_types_to_uploads');

// ----- Custom post type ------//

function clientlogos() {
 register_post_type( 'clientlogos',
  array(
   'labels' => array(
    'name' => __( 'Clients' ),
    'singular_name' => __( 'Clients' ),    
    'add_new_item' => __('Add Client'),
    'add_new' => __( 'Add Client' )
   ),
    'public' => true,
    'rewrite' => array('slug' => '/client'),
    'supports' => array( 'title', 'editor', 'custom-fields', 'tags'),
    'taxonomies' => array('post_tag'),
    'menu_icon' => 'dashicons-universal-access',
    'menu_position' => 5,
  )
 );
}

// add_action( 'init', 'testimonials' );
function testimonials() {
 register_post_type( 'testimonials',
  array(
   'labels' => array(
    'name' => __( 'Testimonials' ),
    'singular_name' => __( 'Testimonials' ),    
    'add_new_item' => __('Add Testimonial'),
    'add_new' => __( 'Add Testimonial' )
   ),
    'public' => true,
    'rewrite' => array('slug' => '/testimonial'),
    'supports' => array( 'title', 'editor', 'custom-fields', 'tags'),
    'taxonomies' => array('post_tag'),
    'menu_icon' => 'dashicons-universal-access',
    'menu_position' => 7,
  )
 );
}

function mycertificates() {
  register_post_type( 'certificates',
   array(
    'labels' => array(
     'name' => __( 'Certificates' ),
     'singular_name' => __( 'Certificates' ),    
     'add_new_item' => __('Add Certificate'),
     'add_new' => __( 'Add Certificate' )
    ),
     'public' => true,
     'rewrite' => array('slug' => '/certificates'),
     'supports' => array( 'title', 'editor', 'custom-fields', 'tags'),
     'taxonomies' => array('post_tag'),
     'menu_icon' => 'dashicons-universal-access',
     'menu_position' => 7,
   )
  );
 }

 function portfolios() {
  register_post_type( 'portfolio',
   array(
    'labels' => array(
     'name' => __( 'Portfolio' ),
     'singular_name' => __( 'Portfolio' ),    
     'add_new_item' => __('Add Portfolio'),
     'add_new' => __( 'Add Portfolio' )
    ),
     'public' => true,
     'rewrite' => array('slug' => '/portfolio'),
     'supports' => array( 'title', 'editor', 'custom-fields', 'tags'),
     'taxonomies' => array('post_tag','portfolio_category'),
     'menu_icon' => 'dashicons-universal-access',
     'menu_position' => 7,
   )
  );

	register_post_type( 'portfolio_category',
		array(
			'labels' => array(
				'name' => __( 'Portfolio Category' ),
				'singular_name' => __( 'Portfolio Category' ),    
				'add_new_item' => __('Add New'),
				'add_new' => __( 'Add New' )
			),
			'public' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => '/portfolio_category', 'with_front' => true),
			'supports' => array( 'title', 'editor', 'custom-fields'),
			'menu_icon' => 'dashicons-format-video',
			'menu_position' => 8,
		)
	);


 }

function theme_posttypes() {
  testimonials();
  clientlogos();
  mycertificates();
  portfolios();
}

add_action( 'init', 'theme_posttypes' );


// Define the callback function for your custom meta box
function add_custom_checkbox_meta_box() {
  add_meta_box(
      'custom-checkbox-meta-box', // Unique ID
      'Custom Checkbox',          // Title
      'render_custom_checkbox_meta_box', // Callback function
      'page',                     // Post type (e.g., 'page' for Pages)
      'side',                     // Context (e.g., 'side' for the sidebar)
      'default'                   // Priority
  );
}

// Register the custom meta box
// add_action('add_meta_boxes', 'add_custom_checkbox_meta_box');

// Callback function to render the custom meta box
function render_custom_checkbox_meta_box($post) {
  // Retrieve the current value of the custom field, if it exists
  $checked = get_post_meta($post->ID, 'custom_checkbox', true);

  // Output the checkbox HTML
  ?>
  <label for="custom-checkbox">
      <input type="checkbox" id="custom-checkbox" name="custom_checkbox" <?php checked($checked, 'on'); ?> />
      Do you want to add client Logos?
    </label>
  <?php
}

// Save the custom checkbox value when the page is updated or published
// add_action('save_post', 'save_custom_checkbox_value');

function save_custom_checkbox_value($post_id) {
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    // Save the checkbox value
    if (isset($_POST['custom_checkbox'])) {
        update_post_meta($post_id, 'custom_checkbox', 'on');
    } else {
        delete_post_meta($post_id, 'custom_checkbox');
    }
}


// add_action( 'init', 'ItSupportTeam' );
function ItSupportTeam() {
 register_post_type( 'ItSupportTeam',
  array(
   'labels' => array(
    'name' => __( 'IT TEAM' ),
    'singular_name' => __( 'IT TEAM' ),    
    'add_new_item' => __('Add Member'),
    'add_new' => __( 'Add Member' )
   ),
    'public' => true,
    'rewrite' => array('slug' => 'it-team'),
    'supports' => array( 'title', 'editor', 'custom-fields', 'tags'),
    'taxonomies' => array('post_tag'),
    'menu_icon' => 'dashicons-universal-access',
    'menu_position' => 5,
  )
 );
}