<?php

  /**
   * Template Name: Home
   * A custom page template for Home page.
   */

  get_header();

?>
    <!-- Animated Background -->
    <div class="lm-animated-bg" style="background-image: url(<?php echo get_template_directory_uri(); ?>/assets/img/main_bg.png);"></div>
    <!-- /Animated Background -->

    <!-- Loading animation -->
    <div class="preloader">
      <div class="preloader-animation">
        <div class="preloader-spinner">
        </div>
      </div>
    </div>
    <!-- /Loading animation -->

    <div class="page">
      <div class="page-content">

          <?php
            get_template_part('template-parts/components/home-header');
          ?>

          <!-- Mobile Navigation -->
          <div class="menu-toggle">
            <span></span>
            <span></span>
            <span></span>
          </div>
          <!-- End Mobile Navigation -->

          <!-- Arrows Nav -->
          <div class="lmpixels-arrows-nav">
            <div class="lmpixels-arrow-right"><i class="lnr lnr-chevron-right"></i></div>
            <div class="lmpixels-arrow-left"><i class="lnr lnr-chevron-left"></i></div>
          </div>
          <!-- End Arrows Nav -->

          <div class="content-area">
            <div class="animated-sections">

              <?php

                get_template_part('template-parts/components/profile-home');              
                get_template_part('template-parts/components/profile-about');
                get_template_part('template-parts/components/profile-resume');
                get_template_part('template-parts/components/profile-portfolio');
                //get_template_part('template-parts/components/profile-blog');
                get_template_part('template-parts/components/profile-contact');

              ?>

            </div>
          </div>

      </div>
    </div>

<?php
  get_footer();
?>