<?php

$currentPageID = CONST_CUSTOM_PAGE_ID;

$tempImage = get_field('profile_image',$currentPageID);

$profileImage = esc_url($tempImage['url']);
$profileName = get_field('profile_name',$currentPageID);
$profileType = get_field('profile_type',$currentPageID);
$profileTags = get_field('profile_tags',$currentPageID);


$socialPlatform = array();
$socialURL = array();

if(have_rows('social_icons',$currentPageID)){
    while(have_rows('social_icons',$currentPageID)){
        the_row();      

        $socialPlatform[] = get_sub_field('social_platform',$currentPageID);
        $socialURL[] = get_sub_field('social_url',$currentPageID);

    }
}

$downloadCVLabel = get_field('download_cv_label',$currentPageID);

$downloadCVURL = esc_url($tempImage['url']);
$copyrightContent = get_field('copyright_content',$currentPageID);
$year = date("Y");
$copyrightContent = str_replace('[year]',$year,$copyrightContent);

$profileFreelancerTypeLabel = array();

if(have_rows('profile_freelancer_type',$currentPageID)){
    while(have_rows('profile_freelancer_type',$currentPageID)){
        the_row();      

        $profileFreelancerTypeLabel[] = get_sub_field('profile_freelancer_type_label',$currentPageID);

    }
}

$siteURL = home_URL();

if(is_front_page() || is_home()){
    $siteURL = "";
}

?>
<style>
    .header-titles p{
        color:#fff;
    }
</style>
<header id="site_header" class="header mobile-menu-hide">
    <div class="header-content">
        <?php
            if($profileImage){
        ?>
                <div class="header-photo">
                    <img src="<?php echo($profileImage); ?>" alt="<?php echo($profileName); ?>">
                </div>
        <?php
            }
        ?>
        <div class="header-titles">
            <?php
                if($profileName){
            ?>
                    <h2><?php echo($profileName); ?></h2>
            <?php
                }
                if($profileType){
            ?>
                    <h4><?php echo($profileType); ?></h4>
            <?php
                }
            ?>
        </div>
    </div>

    <ul class="main-menu">
        <li class="active">
            <a href="<?php echo($siteURL); ?>#home" class="nav-anim">
                <span class="menu-icon lnr lnr-home"></span>
                <span class="link-text">Home</span>
            </a>
        </li>
        <li>
            <a href="<?php echo($siteURL); ?>#about-me" class="nav-anim">
                <span class="menu-icon lnr lnr-user"></span>
                <span class="link-text">About Me</span>
            </a>
        </li>
        <li>
            <a href="<?php echo($siteURL); ?>#resume" class="nav-anim">
                <span class="menu-icon lnr lnr-graduation-hat"></span>
                <span class="link-text">Resume</span>
            </a>
        </li>
        <li>
            <a href="<?php echo($siteURL); ?>#portfolio" class="nav-anim">
                <span class="menu-icon lnr lnr-briefcase"></span>
                <span class="link-text">Portfolio</span>
            </a>
        </li>

        <li>
            <a href="<?php echo($siteURL); ?>#contact" class="nav-anim">
                <span class="menu-icon lnr lnr-envelope"></span>
                <span class="link-text">Contact</span>
            </a>
        </li>
    </ul>

    <?php
        if(sizeof($socialPlatform) > 0 ){
    ?>
            <div class="social-links">
                <ul>
                    <?php
                        for($counter=0; $counter < sizeof($socialPlatform); $counter++ ){
                    ?>
                        <li>
                            <a href="<?php echo($socialURL[$counter]); ?>" target="_blank">
                                <i class="fab <?php echo($socialPlatform[$counter]); ?>"></i>
                            </a>
                        </li>
                    <?php
                        }
                    ?>
                </ul>
            </div>
    <?php
        }
    ?>
    <div class="header-content">
        
        <div class="header-titles">
            <?php                
                if($profileTags){
            ?>
                    <p><?php echo($profileTags); ?></p>
            <?php
                }
            ?>
        </div>
    </div>
    <?php
        if($downloadCVLabel){
    ?>
        <div class="header-buttons">
            <a href="#contact" class="btn btn-primary "><?php echo($downloadCVLabel); ?></a>
        </div>
    <?php
        }
    ?>

    <div class="copyrights"><?php echo($copyrightContent); ?></div>
</header>