<?php

$currentPageID = CONST_ABOUT_PAGE_ID;

$profileAboutClientsHeading = get_field('profile_about_clients_heading',$currentPageID);

$clientTitle = array();
$tempImage = array();
$clientLogo = array();
$clientLogoAlt = array();
$clientURL = array();

$clientQuery = new WP_Query( 

                    array( 
                        'post_type' => 'clientlogos',
                        'order' => 'DESC',
                        'posts_per_page' => -1,
                        )
                    ); 

while ( $clientQuery->have_posts() ) {

    $clientQuery->the_post();
    
    $tempID = get_the_ID();
    
    $clientTitle[] = get_the_title();
    $tempImage = get_field('profile_client_logo',$tempID);
    $clientLogo[] = esc_url($tempImage['url']);
    $clientLogoAlt[] = esc_attr($tempImage['alt']);
    $clientURL[] = get_field('profile_client_url',$tempID);

}

?>

<?php
    if(sizeof($clientTitle) > 0 ){
?>
    <div class="white-space-50"></div>

    <!-- Clients -->
    <div class="row">
        <div class="col-xs-12 col-sm-12">
            <div class="block-title">
                <?php 
                    $tempArray = explode(",",$profileAboutClientsHeading);
                    if(sizeof($tempArray) > 1 ){
                ?>
                        <h3><?php echo($tempArray[0]); ?> <span><?php echo($tempArray[1]); ?></span></h3>
                <?php
                    }
                    else{
                ?>
                        <h3><?php echo($profileAboutClientsHeading); ?></h3>
                <?php
                    }
                ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12">
            <div class="clients owl-carousel">
                <?php
                    for($counter=0; $counter < sizeof($clientTitle); $counter++ ){
                        if($clientLogo[$counter]){
                    ?>
                        <div class="client-block">                        
                            <a href="<?php echo($clientURL[$counter]); ?>" target="_blank" title="<?php echo($clientTitle[$counter]); ?>">
                                <img src="<?php echo($clientLogo[$counter]); ?>" alt="<?php echo($clientLogoAlt[$counter]); ?>">
                            </a>                        
                        </div>
                    <?php
                        }
                    }
                ?>
            </div>
        </div>
    </div>
    <!-- End of Clients -->

<?php
    }
?>