<?php

$currentPageID = CONST_ABOUT_PAGE_ID;

$profileAboutTestimonialsHeading = get_field('profile_about_testimonials_heading',$currentPageID);

$profileTestimonialTitle = array();
$profileTestimonialImageURL = array();
$profileTestimonialImageAlt = array();
$profileTestimonialContent = array();
$profileTestimonialName = array();
$profileTestimonialDesignation = array();

$clientQuery = new WP_Query( 

                    array( 
                        'post_type' => 'testimonials',
                        'order' => 'DESC',
                        'posts_per_page' => -1,
                        )
                    ); 

while ( $clientQuery->have_posts() ) {

    $clientQuery->the_post();
    
    $tempID = get_the_ID();
    
    $profileTestimonialTitle[] = get_the_title();
    $tempImage = get_field('profile_testimonial_image',$tempID);
    $profileTestimonialImageURL[] = esc_url($tempImage['url']);
    $profileTestimonialImageAlt[] = esc_attr($imtempImageage['alt']);
    $profileTestimonialContent[] = get_field('profile_testimonial_content',$tempID);
    $profileTestimonialName[] = get_field('profile_testimonial_name',$tempID);
    $profileTestimonialDesignation[] = get_field('profile_testimonial_designation',$tempID);

}

?>

<?php
    if(sizeof($profileTestimonialTitle) > 0 ){
?>
    <div class="white-space-50"></div>

    <!-- Testimonials -->
    <div class="row">
        <div class="col-xs-12 col-sm-12">
            <div class="block-title">
                <?php 
                    $tempArray = explode(",",$profileAboutTestimonialsHeading);
                    if(sizeof($tempArray) > 1 ){
                ?>
                        <h3><?php echo($tempArray[0]); ?> <span><?php echo($tempArray[1]); ?></span></h3>
                <?php
                    }
                    else{
                ?>
                        <h3><?php echo($tempArray[0]); ?></h3>
                <?php
                    }
                ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-12">
            <div class="testimonials owl-carousel">

                <?php
                    for($counter=0; $counter < sizeof($profileTestimonialTitle); $counter++ ){
                ?>
                        <!-- Testimonial <?php $counter; ?> -->
                        <div class="testimonial">
                            <div class="img">
                                <img src="<?php echo($profileTestimonialImageURL[$counter]); ?>" alt="<?php echo($profileTestimonialTitle[$counter]); ?>">
                            </div>
                            <div class="text">
                                <?php echo($profileTestimonialContent[$counter]); ?>
                            </div>

                            <div class="author-info">
                                <h4 class="author"><?php echo($profileTestimonialName[$counter]); ?></h4>
                                <h5 class="company"><?php echo($profileTestimonialDesignation[$counter]); ?></h5>
                                <div class="icon">
                                    <i class="fas fa-quote-right"></i>
                                </div>
                            </div>
                        </div>
                        <!-- End of Testimonial <?php $counter; ?> -->
                <?php
                    }
                ?>

            </div>
        </div>
    </div>
    <!-- End of Testimonials -->

<?php
    }
?>