<?php

$currentPageID = get_the_ID();

$profileBlogTitle = get_the_title($currentPageID);

$tempImage = get_field('profile_blog_large_image',$currentPageID);
$profileBlogLargeImage = esc_url($tempImage['url']);
$profileBlogLargeImageAlt = esc_attr($tempImage['alt']);

$profileBlogContent = get_field('profile_blog_content',$currentPageID);

$profileBlogDate = get_field('profile_blog_date',$currentPageID);

$profileBlogTag = array();

$posttags = get_the_tags($currentPageID);
if ($posttags) {
  foreach($posttags as $tag) {
    $profileBlogTag[] = $tag->name; 
  }
}


?>
<article class="post">

    <?php
        if($profileBlogLargeImage){
    ?>
        <div class="post-thumbnail">
            <img src="<?php echo($profileBlogLargeImage); ?>" alt="<?php echo($profileBlogTitle); ?>">
        </div>
    <?php
        }
    ?>

    <div class="post-content">
        <!-- /Entry header -->
        <header class="entry-header">
            <!-- Entry meta -->
            <div class="entry-meta entry-meta-top">
                <span><a href="#" rel="category tag">UI</a></span>
            </div>
            <!-- /Entry meta -->

            <h2 class="entry-title"><?php echo($profileBlogTitle); ?></h2>
        </header>
        <!-- /Entry header -->

        <!-- Entry content -->
        <div class="entry-content">
            <div class="row">
                <div class=" col-xs-12 col-sm-12 ">
                    <div class="col-inner">
                        <?php echo($profileBlogContent); ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Entry content -->

        <div class="entry-meta entry-meta-bottom">
            <div class="date-author">
                <span class="entry-date">
                    <a href="#" rel="bookmark">
                        <i class="far fa-clock"></i> <span class="entry-date"> <?php echo($profileBlogDate); ?></span>
                    </a>
                </span>
                <!-- <span class="author vcard">
                    <a class="url fn n" href="#" rel="author"> <i class="fas fa-user"></i> LMPixels</a>
                </span> -->
            </div>

            <!-- Share Buttons -->
            <div class="entry-share btn-group share-buttons">
                <a href="#"
                    onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600');return false;"
                    class="btn" target="_blank" title="Share on Facebook">
                    <i class="fab fa-facebook-f"></i>
                </a>

                <a href="#"
                    onclick="javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=300,width=600');return false;"
                    class="btn" target="_blank" title="Share on Twitter">
                    <i class="fab fa-twitter"></i>
                </a>

                <a href="#"
                    onclick="javascript:window.open(this.href,'', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;"
                    class="btn" title="Share on LinkedIn">
                    <i class="fab fa-linkedin-in"></i>
                </a>
            </div>
            <!-- /Share Buttons -->
        </div>

        <?php
            if(sizeof($profileBlogTag) > 0 ){
        ?>
            <div class="post-tags">
                <ul class="tags">
                    <?php
                        for($counter=0; $counter < sizeof($profileBlogTag); $counter++ )
                        {
                    ?>
                            <li><a><?php echo($profileBlogTag[$counter]); ?></a></li>
                    <?php
                        }
                    ?>
                </ul>
            </div>
        <?php
            }
        ?>

    </div>
</article>