<?php

$currentPageID = CONST_BLOG_PAGE_ID;

$profilePortfolioBlogLabel = get_field('profile_portfolio_blog_label',$currentPageID);

$profileBlogTitle =  array();
$profileBlogThumb =  array();
$profileBlogThumbAlt = array();
$profileBlogDate =  array();
$profileBlogPermalink =  array();

$postQuery = new WP_Query( 

    array( 
        'post_type' => 'post',
        'order' => 'DESC',
        'posts_per_page' => -1,
        )
    ); 

while ( $postQuery->have_posts() ) {

    $postQuery->the_post();

    $tempID = get_the_ID();

    $profileBlogTitle[] = get_field('profile_blog_title',$tempID);

    $tempImage = get_field('profile_blog_thumb',$tempID);
    $profileBlogThumb[] = esc_url($tempImage['url']);
    $profileBlogThumbAlt[] = esc_attr($tempImage['alt']);

    $profileBlogDate[] = get_field('profile_blog_date',$tempID);
    $profileBlogPermalink[] = get_the_permalink($tempID);

}

?>

<!-- Blog Subpage -->
<section data-id="blog" class="animated-section">
    <div class="section-content">
        <div class="page-title">
            <?php 
                $tempArray = explode(",",$profilePortfolioBlogLabel);
                if(sizeof($tempArray) > 1 ){
            ?>
                    <h2><?php echo($tempArray[0]); ?> <span><?php echo($tempArray[1]); ?></span></h2>
            <?php
                }
                else{
            ?>
                    <h2><?php echo($tempArray[0]); ?></h2>
            <?php
                }
            ?>
        </div>
        <?php
            if(sizeof($profileBlogTitle) > 0){
        ?>

        <div class="row">
            <div class="col-xs-12 col-sm-12">
                <div class="blog-masonry two-columns clearfix">

                    <?php
                        for($counter=0; $counter < sizeof($profileBlogTitle); $counter++ ){
                    ?>
                        <!-- Blog Post 1 -->
                        <div class="item post-1">
                            <div class="blog-card">
                                <div class="media-block">
                                    <div class="category">
                                        <a href="#" title="View all posts in Design">Design</a>
                                    </div> 
									
                                    <?php
                                        if($profileBlogThumb[$counter]){
                                    ?>
                                        <a href="<?php echo($profileBlogPermalink[$counter]); ?>">
                                            <img src="<?php echo($profileBlogThumb[$counter]); ?>" class="size-blog-masonry-image-two-c"
                                                alt="<?php echo($profileBlogTitle[$counter]); ?>" title="" />
                                            <div class="mask"></div>
                                        </a>
                                    <?php
                                        }
                                    ?>
									
                                </div>
                                <div class="post-info">
                                    <?php 
                                        if($profileBlogDate[$counter]){
                                    ?>
                                        <div class="post-date"><?php echo($profileBlogDate[$counter]); ?></div>
                                    <?php
                                        }
                                    ?>
                                    <a href="<?php echo($profileBlogPermalink[$counter]); ?>">
                                        <h4 class="blog-item-title"><?php echo($profileBlogTitle[$counter]); ?></h4>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <!-- End of Blog Post 1 -->
                    <?php
                        }
                    ?>
                   
                </div>
            </div>
        </div>
        <?php
            }
        ?>
    </div>
    
</section>
<!-- End of Blog Subpage -->