<?php

$currentPageID = CONST_CUSTOM_PAGE_ID;

$profileContactHeading = get_field('profile_contact_heading',$currentPageID);
$profileContactLocation = get_field('profile_contact_location',$currentPageID);
$profileContactPhone = get_field('profile_contact_phone',$currentPageID);
$profileContactEmail = get_field('profile_contact_email',$currentPageID);
$profileContactFreelance = get_field('profile_contact_freelance',$currentPageID);
$profileSiteKey = get_field('profile_site_key',$currentPageID);
$profileSecretKey = get_field('profile_secret_key',$currentPageID);

?>

<style>
    #contact .lm-info-block a:hover{
        color:#222 !important;
    }
</style>

<!-- Contact Subpage -->
<section data-id="contact" class="animated-section">
    <div class="section-content">
        <div class="page-title">
            <?php 
                $tempArray = explode(",",$profileContactHeading);
                if(sizeof($tempArray) > 1 ){
            ?>
                    <h2><?php echo($tempArray[0]); ?> <span><?php echo($tempArray[1]); ?></span></h2>
            <?php
                }
                else{
            ?>
                    <h2><?php echo($tempArray[0]); ?></h2>
            <?php
                }
            ?>
        </div>

        <div class="row">
            <!-- Contact Info -->
            <div class="col-xs-12 col-sm-4">
                <div class="lm-info-block gray-default">
                    <i class="lnr lnr-map-marker"></i>
                    <h4><?php echo($profileContactHeading); ?></h4>
                    <span class="lm-info-block-value"></span>
                    <span class="lm-info-block-text"></span>
                </div>

                <div class="lm-info-block gray-default">
                    <i class="lnr lnr-phone-handset"></i>
                    <h4><a href="tel:<?php echo($profileContactPhone); ?>"><?php echo($profileContactPhone); ?></a></h4>
                    <span class="lm-info-block-value"></span>
                    <span class="lm-info-block-text"></span>
                </div>

                <div class="lm-info-block gray-default">
                    <i class="lnr lnr-envelope"></i>
                    <h4><a href="mailto:<?php echo($profileContactEmail); ?>"><?php echo($profileContactEmail); ?></a></h4>
                    <span class="lm-info-block-value"></span>
                    <span class="lm-info-block-text"></span>
                </div>

                <div class="lm-info-block gray-default">
                    <i class="lnr lnr-checkmark-circle"></i>
                    <h4><?php echo($profileContactFreelance); ?></h4>
                    <span class="lm-info-block-value"></span>
                    <span class="lm-info-block-text"></span>
                </div>


            </div>
            <!-- End of Contact Info -->

            <!-- Contact Form -->
            <div class="col-xs-12 col-sm-8">
                <div class="block-title">
                    <h3>How Can I <span>Help You?</span></h3>
                </div>

                <form id="contact_form_1" class="contact-form" action="<?php echo get_template_directory_uri(); ?>/contact_form.php" method="post">

                    <div class="messages"></div>

                    <div class="controls two-columns">
                        <div class="fields clearfix">
                            <div class="left-column">
                                <div class="form-group form-group-with-icon">
                                    <input id="form_name" type="text" name="u_name" class="form-control" placeholder=""
                                        required="required" data-error="Name is required.">
                                    <label>Full Name</label>
                                    <div class="form-control-border"></div>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group form-group-with-icon">
                                    <input id="form_email" type="email" name="u_email" class="form-control" placeholder=""
                                        required="required" data-error="Valid email is required.">
                                    <label>Email Address</label>
                                    <div class="form-control-border"></div>
                                    <div class="help-block with-errors"></div>
                                </div>

                                <div class="form-group form-group-with-icon">
                                    <input id="form_subject" type="text" name="u_subject" class="form-control"
                                        placeholder="" required="required" data-error="Subject is required.">
                                    <label>Subject</label>
                                    <div class="form-control-border"></div>
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>
                            <div class="right-column">
                                <div class="form-group form-group-with-icon">
                                    <textarea id="form_message" name="u_message" class="form-control" placeholder=""
                                        rows="7" required="required"
                                        data-error="Please, leave me a message."></textarea>
                                    <label>Message</label>
                                    <div class="form-control-border"></div>
                                    <div class="help-block with-errors"></div>
                                </div>
                            </div>
                        </div>

                        <div class="g-recaptcha" data-sitekey="<?php echo($profileSiteKey); ?>" data-theme="light"></div>

                        <input type="submit" class="button btn-send" value="Send message">
                    </div>
                </form>
            </div>
            <!-- End of Contact Form -->
        </div>

    </div>
</section>
<!-- End of Contact Subpage -->