<?php

$parentPageID = CONST_PORTFOLIO_PAGE_ID;

$currentPageID = get_the_ID();

$profilePortfolioTitle = get_field('profile_portfolio_title',$currentPageID);

$profilePortfolioImageURL = array();
$profilePortfolioImageAlt = array();


if(have_rows('profile_portfolio_images',$currentPageID)){
    while(have_rows('profile_portfolio_images',$currentPageID)){
        the_row();      
        
        $tempImage = get_sub_field('profile_portfolio_image',$currentPageID);
        $profilePortfolioImageURL[] = esc_url($tempImage['url']);
        $profilePortfolioImageAlt[] = esc_attr($tempImage['alt']);
        
    }
}

$profilePortfolioVideo = get_field('profile_portfolio_video',$currentPageID);
$profilePortfolioName = get_field('profile_portfolio_name',$currentPageID);
$profilePortfolioWebsite = get_field('profile_portfolio_website',$currentPageID);
$profilePortfolioDate = get_field('profile_portfolio_date',$currentPageID);
$profilePortfolioContent = get_field('profile_portfolio_content',$currentPageID);

$profilePortfolioTag = array();

$posttags = get_the_tags($currentPageID);
if ($posttags) {
  foreach($posttags as $tag) {
    $profilePortfolioTag[] = $tag->name; 
  }
}

$profilePortfolioDescriptionLabel = get_field('profile_portfolio_description_label',$currentPageID);
$profilePortfolioTechnologyLabel = get_field('profile_portfolio_technology_label',$currentPageID);

?>


<div id="ajax-page" class="ajax-page-content">
    <div class="ajax-page-wrapper">

        <div class="ajax-page-nav">
            <div class="nav-item ajax-page-prev-next">
                <a class="ajax-page-load" href="portfolio-3.html"><i class="lnr lnr-chevron-left"></i></a>
                <a class="ajax-page-load" href="portfolio-2.html"><i class="lnr lnr-chevron-right"></i></a>
            </div>
            <div class="nav-item ajax-page-close-button">
                <a id="ajax-page-close-button" href="#"><i class="lnr lnr-cross"></i></a>
            </div>
        </div>

        <div class="ajax-page-title">
            <h1><?php echo($profilePortfolioTitle); ?></h1>
        </div>

        <div class="row">
            <div class="col-sm-8 col-md-8 portfolio-block">
                <?php
                    if(sizeof($profilePortfolioImageURL) > 0 ){
                ?>
                    <div class="owl-carousel portfolio-page-carousel">
                        <?php
                            for($counter=0; $counter < sizeof($profilePortfolioImageURL); $counter++ )
                            {
                        ?>
                            <div class="item">
                                <img src="<?php echo($profilePortfolioImageURL[$counter]); ?>" alt="<?php echo($profilePortfolioImageAlt[$counter]); ?>" />
                            </div>
                        <?php
                            }
                        ?>                    
                    </div>
                    <script type="text/javascript">
                        jQuery(document).ready(function($){
                            $('.portfolio-page-carousel').imagesLoaded(function(){
                                $('.portfolio-page-carousel').owlCarousel({
                                    smartSpeed:1200,
                                    items: 1,
                                    loop: true,
                                    dots: true,
                                    nav: true,
                                    navText: false,
                                    margin: 10,
                                    autoHeight:true
                                });
                            });
                        });
                    </script>
                <?php
                    }

                    if($profilePortfolioVideo){
                ?>
                        <div class="portfolio-page-video embed-responsive embed-responsive-16by9">
                            <iframe class="embed-responsive-item" src="<?php echo($profilePortfolioVideo); ?>"></iframe>
                        </div>
                <?php
                    }
                ?>
                
            </div>

            <div class="col-sm-4 col-md-4 portfolio-block">
                <!-- Project Description -->
                <div class="project-description">
                    <div class="block-title">
                        <h3><?php echo($profilePortfolioDescriptionLabel); ?></h3>
                    </div>
                    <ul class="project-general-info">
                        <li><p><i class="fa fa-user"></i> <?php echo($profilePortfolioName); ?></p></li>
                        <li><p><i class="fa fa-globe"></i> <a href="<?php echo($profilePortfolioWebsite); ?>" target="_blank"><?php echo($profilePortfolioWebsite); ?></a></p></li>
                        <li><p><i class="fa fa-calendar"></i> <?php echo($profilePortfolioDate); ?></p></li>
                    </ul>

                    <!-- <p class="text-justify">Aliquam euismod aliquam massa, quis eleifend dui sodales vitae. Interdum et malesuada fames ac ante ipsum primis in faucibus.</p> -->
                    <?php echo($profilePortfolioContent); ?>
                    <!-- /Project Description -->

                    <?php
                        if(sizeof($profilePortfolioTag) > 0 ){
                    ?>
                        <!-- Technology -->
                        <div class="tags-block">
                            <div class="block-title">
                                <h3><?php echo($profilePortfolioTechnologyLabel); ?></h3>
                            </div>
                            <ul class="tags">
                                <?php
                                    for($counter=0; $counter < sizeof($profilePortfolioTag); $counter++ )
                                    {
                                ?>
                                        <li><a><?php echo($profilePortfolioTag[$counter]); ?></a></li>
                                <?php
                                    }
                                ?>
                            </ul>
                        </div>
                        <!-- /Technology -->
                    <?php
                        }
                    ?>

                    <!-- Share Buttons -->
                    <div class="btn-group share-buttons">
                        <div class="block-title">
                            <h3>Share</h3>
                        </div>
                        <a href="#" target="_blank" class="btn"><i class="fab fa-facebook-f"></i> </a>
                        <a href="#" target="_blank" class="btn"><i class="fab fa-twitter"></i> </a>
                        <a href="#" target="_blank" class="btn"><i class="fab fa-dribbble"></i> </a>
                    </div>
                    <!-- /Share Buttons -->
                </div>
                <!-- Project Description -->
            </div>
        </div>
    </div>
</div>

