<?php

$currentPageID = CONST_PORTFOLIO_PAGE_ID;

$profilePortfolioHeading = get_the_title($currentPageID);

$portfolioCategoryTopTitle = array();
$portfolioCategoryTopName = array();

$clientQuery = new WP_Query( 

                    array( 
                        'post_type' => 'portfolio_category',
                        'order_by' => 'title',
                        'order' => 'ASC',
                        'posts_per_page' => -1,
                        )
                    ); 

while ( $clientQuery->have_posts() ) {

    $clientQuery->the_post();
    
    $tempID = get_the_ID();
    
    $tempValue =  get_field('portfolio_category_title',$tempID);

    $portfolioCategoryTopTitle[] = $tempValue;
    $portfolioCategoryTopName[] = strtolower(str_replace(" ","_",$tempValue));
    
}

$profilePortfolioPermalink = array();
$profilePortfolioType = array();
$profilePortfolioTitle = array();
$profilePortfolioThumbnail = array();
$profilePortfolioThumbnailAlt = array();
$profilePortfolioGeneralVideo = array();
$portfolioCategoryName = array();
$profilePortfolioGeneralImageURL = array();
$profilePortfolioGeneralImageAlt = array();
$profilePortfolioGeneralIcon = array();
$profilePortfolioGeneralClass = array();

$clientQuery = new WP_Query( 

                    array( 
                        'post_type' => 'portfolio',
                        'order' => 'DESC',
                        'posts_per_page' => -1,
                        )
                    ); 

while ( $clientQuery->have_posts() ) {

    $clientQuery->the_post();
    
    $tempID = get_the_ID();

    $tempImage = array();
    
    $profilePortfolioTitle[] = get_field('profile_portfolio_title',$tempID);

    $tempImage = get_field('profile_portfolio_thumbnail',$tempID);
    $profilePortfolioThumbnailURL[] = esc_url($tempImage['url']);
    $profilePortfolioThumbnailAlt[] = esc_attr($tempImage['alt']);

    $tempVideoURL = get_field('profile_portfolio_general_video',$tempID);        

    $tempImage = get_field('profile_portfolio_general_image',$tempID);

    $tempImageURL = '';
    $tempImageAlt = '';

    if(get_field('profile_portfolio_general_image',$tempID) ){
        $tempImageURL = esc_url($tempImage['url']);
        $tempImageAlt = esc_attr($tempImage['alt']);
    }

    $profilePortfolioGeneralImageURL[] = $tempImageURL;
    $profilePortfolioGeneralImageAlt[] = $tempImageAlt;

    $portfolioCategoryName[] = get_field('portfolio_category_title',get_field('profile_portfolio_category',$tempID));

    $tempValue = get_field('profile_portfolio_type',$tempID);
    $profilePortfolioType[] = $tempValue;

    switch ($tempValue){
        case 'lbaudio':
            $tempIcon = 'fa-volume-up';
            $tempClass = 'lightbox mfp-iframe';
            $tempPermalink = $tempVideoURL;
            break;
        case 'standard':
            $tempIcon = 'fa-file-alt';
            $tempClass = 'ajax-page-load';
            $tempPermalink = get_the_permalink($tempID);
            break;
        case 'lbvideo':
            $tempIcon = 'fa-video';
            $tempClass = 'lightbox mfp-iframe';
            $tempPermalink = $tempVideoURL;
            break;
        case 'lbimage':
            $tempIcon = 'fa-image';
            $tempClass = 'lightbox';
            $tempPermalink = esc_url($tempImage['url']);
            break;
    } 

    $profilePortfolioGeneralIcon[] = $tempIcon;
    $profilePortfolioGeneralClass[] = $tempClass;
    $profilePortfolioPermalink[] = $tempPermalink;
            
}

?>


<!-- Portfolio Subpage -->
<section data-id="portfolio" class="animated-section">
    <div class="section-content">
        <div class="page-title">
            <?php 
                $tempArray = explode(",",$profilePortfolioHeading);
                if(sizeof($tempArray) > 1 ){
            ?>
                    <h2><?php echo($tempArray[0]); ?> <span><?php echo($tempArray[1]); ?></span></h2>
            <?php
                }
                else{
            ?>
                    <h2><?php echo($profilePortfolioHeading); ?></h2>
            <?php
                }
            ?>
        </div>

        <?php
            if(sizeof($profilePortfolioTitle) > 0 ){
        ?>
            <div class="row">
                <div class="col-xs-12 col-sm-12">
                    <!-- Portfolio Content -->
                    <div class="portfolio-content">

                        <ul class="portfolio-filters">
                            <li class="active">
                                <a class="filter btn btn-sm btn-link" data-group="category_all">All</a>
                            </li>
                            <?php
                                for($counter=0; $counter < sizeof($portfolioCategoryTopTitle); $counter++ ){
                            ?>
                                <li>
                                    <a class="filter btn btn-sm btn-link"
                                        data-group="category_<?php echo($portfolioCategoryTopName[$counter]); ?>"><?php echo($portfolioCategoryTopTitle[$counter]); ?></a>
                                </li>
                            <?php
                                }
                            ?>
                        </ul>

                        <!-- Portfolio Grid -->
                        <div class="portfolio-grid three-columns">
                        
                        <?php
                            for($counter=0; $counter < sizeof($profilePortfolioTitle); $counter++ ){
                                $tempArray =  array();                            
                        ?>                            
                                <figure class="item <?php echo($profilePortfolioType[$counter]); ?>" data-groups='["category_all", "<?php echo(strtolower(str_replace(" ","_","category_".$portfolioCategoryName[$counter]))); ?>"]'>
                                    <div class="portfolio-item-img">
                                        <img src="<?php echo($profilePortfolioThumbnailURL[$counter]); ?>" alt="<?php echo($profilePortfolioThumbnailAlt[$counter]); ?>" title="" />
                                        <a href="<?php echo($profilePortfolioPermalink[$counter]); ?>"
                                            class="<?php echo($profilePortfolioGeneralClass[$counter]); ?>" title="<?php echo($profilePortfolioTitle[$counter]); ?>"></a>
                                    </div>

                                    <i class="fa <?php echo($profilePortfolioGeneralIcon[$counter]); ?>"></i>
                                    <h4 class="name"><?php echo($profilePortfolioTitle[$counter]); ?></h4>
                                    <span class="category"><?php echo($portfolioCategoryName[$counter]); ?></span>

                                </figure>
                        <?php
                            }
                        ?>

                        </div>
                    </div>
                    <!-- End of Portfolio Content -->
                </div>
            </div>
        <?php
            }
        ?>
    </div>
</section>
<!-- End of Portfolio Subpage -->

