<?php

$currentPageID = CONST_RESUME_PAGE_ID;

$profileCertificatesHeading = get_field('profile_certificates_heading',$currentPageID);

$profileCertificateTitle = array();
$profileCertificateLogoURL = array();
$profileCertificateLogoAlt = array();
$profileCertificateDate = array();
$profileCertificateMemberLabel = array();
$profileCertificateMemberValue = array();

$clientQuery = new WP_Query( 

                    array( 
                        'post_type' => 'certificates',                        
                        'order' => 'DESC',
                        'posts_per_page' => -1,
                        )
                    ); 

while ( $clientQuery->have_posts() ) {

    $clientQuery->the_post();
    
    $tempID = get_the_ID();
    
    // $tempValue = get_field('profile_certificate_title',$tempID);    
    // get_field('profile_certificate_title',$tempID);

    $profileCertificateTitle[] = get_the_title();
    $tempImage = get_field('profile_certificate_logo',$tempID);
    $profileCertificateLogoURL[] = esc_url($tempImage['url']);
    $profileCertificateLogoAlt[] = esc_attr($tempImage['alt']);
    $profileCertificateDate[] = get_field('profile_certificate_date',$tempID);
    $profileCertificateMemberLabel[] = get_field('profile_certificate_member_label',$tempID);
    $profileCertificateMemberValue[] = get_field('profile_certificate_member_value',$tempID);

}

?>

<?php
    if(sizeof($profileCertificateTitle) > 0 ){
?>

    <div class="white-space-50"></div>

    <!-- Certificates -->
    <div class="row">
        <div class="col-xs-12 col-sm-12">
            <div class="block-title">
                <?php 
                    $tempArray = explode(",",$profileCertificatesHeading);
                    if(sizeof($tempArray) > 1 ){
                ?>
                        <h3><?php echo($tempArray[0]); ?> <span><?php echo($tempArray[1]); ?></span></h3>
                <?php
                    }
                    else{
                ?>
                        <h3><?php echo($profileCertificatesHeading); ?></h3>
                <?php
                    }
                ?>
            </div>
        </div>
    </div>

    <div class="row">
        <?php

            for($counter=0; $counter < sizeof($profileCertificateTitle); $counter++ )
            {
        ?>
                <!-- Certificate 1 -->
                <div class="col-xs-12 col-sm-6">
                    <div class="certificate-item clearfix">
                        <div class="certi-logo">
                            <img src="<?php echo($profileCertificateLogoURL[$counter]); ?>" alt="<?php echo($profileCertificateTitle[$counter]); ?>">
                        </div>

                        <div class="certi-content">
                            <div class="certi-title">
                                <h4><?php echo($profileCertificateTitle[$counter]); ?></h4>
                            </div>
                            <div class="certi-id">
                                <span><?php echo($profileCertificateMemberLabel[$counter]); ?>: <?php echo($profileCertificateMemberValue[$counter]); ?></span>
                            </div>
                            <div class="certi-date">
                                <span><?php echo($profileCertificateDate[$counter]); ?></span>
                            </div>
                            <div class="certi-company">
                                <span></span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of Certificate 1 -->
        <?php
            }
        ?>    

    </div>
    <!-- End of Certificates -->
<?php
    }
?>