<?php
    $footer_title = get_field('footer_title', CONST_SITE_INFORMATION_PAGE_ID);
    $footer_description = get_field('footer_description', CONST_SITE_INFORMATION_PAGE_ID);
    $footer_menu = get_field('footer_menu', CONST_SITE_INFORMATION_PAGE_ID);
        // menu_label
        // menu_url
    $call_support_label = get_field('call_support_label', CONST_SITE_INFORMATION_PAGE_ID);
    $call_support_url = get_field('call_support_url', CONST_SITE_INFORMATION_PAGE_ID);
    $email_support_label = get_field('email_support_label', CONST_SITE_INFORMATION_PAGE_ID);
    $email_support_url = get_field('email_support_url', CONST_SITE_INFORMATION_PAGE_ID);
    $social_links = get_field('social_links', CONST_SITE_INFORMATION_PAGE_ID);
        // social_link
        // social_icon
    $copyright_text = get_field('copyright_text', CONST_SITE_INFORMATION_PAGE_ID);
    $copyright_url = get_field('copyright_url', CONST_SITE_INFORMATION_PAGE_ID);
    $privacy_policy_label = get_field('privacy_policy_label', CONST_SITE_INFORMATION_PAGE_ID);
    $privacy_policy_url = get_field('privacy_policy_url', CONST_SITE_INFORMATION_PAGE_ID);
    $terms_of_service_label = get_field('terms_of_service_label', CONST_SITE_INFORMATION_PAGE_ID);
    $terms_of_service_url = get_field('terms_of_service_url', CONST_SITE_INFORMATION_PAGE_ID);
?>
<footer class="footer-section">
            <div class="container--custom">
                <div class="footerWrapper">
                    <div class="infoWrap">
                        <?php
                            if (!empty($footer_title)) 
                            {
                                ?>
                                    <h2 class="heading2"><?php echo $footer_title; ?></h2>
                                <?php
                            }
                            if (!empty($footer_description)) 
                            {
                                ?>
                                    <p><?php echo $footer_description; ?></p>
                                <?php
                            }
                        ?>
                    </div>
                    <div class="linkWrap">
                        <ul>
                            <?php
                                if (!empty($footer_menu)) 
                                {
                                    foreach ($footer_menu as $key => $row)
                                    {
                                        $menu_label = $row['menu_label'];
                                        $menu_url = $row['menu_url'];
                                        if (!empty($menu_label)) 
                                        {
                                            ?>
                                                <li>
                                                    <a href="<?php echo $menu_url; ?>">
                                                        <?php echo $menu_label; ?>
                                                    </a>
                                                </li>
                                            <?php
                                        }
                                    }
                                }
                            ?>
                        </ul>
                    </div>
                    <div class="addressWrap">
                        <ul>
                            <?php
                                if (!empty($call_support_label)) 
                                {
                                    ?>
                                        <li>
                                            <a href="tel:<?php echo $call_support_url; ?>">
                                                <?php echo $call_support_label; ?>
                                            </a>
                                        </li>
                                    <?php
                                }
                                if (!empty($email_support_label)) 
                                {
                                    ?>
                                        <li>
                                            <a href="mailto:<?php echo $email_support_url; ?>">
                                                <?php echo $email_support_label; ?>
                                            </a>
                                        </li>
                                    <?php
                                }
                            ?>
                        </ul>
                    </div>
                    <div class="socialWrap">
                        <ul>
                            <?php
                                if (!empty($social_links)) 
                                {
                                    foreach ($social_links as $key1 => $row1)
                                    {
                                        $social_link = $row1['social_link'];
                                        $social_icon = $row1['social_icon'];
                                        if (!empty($social_link)) 
                                        {
                                            ?>
                                                <li>
                                                    <a href="<?php echo $social_link; ?>" target="_blank">
                                                        <img class="js-tosvg" src="<?php echo $social_icon; ?>" alt="">
                                                    </a>
                                                </li>
                                            <?php
                                        }
                                    }
                                }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="termWrap">
                <div class="container--custom">
                    <div class="innerWrap">
                        <div class="yearWrap">
                            <?php
                                if (!empty($copyright_text)) 
                                {
                                    ?>
                                        <a href="<?php echo $copyright_url; ?>" target="_blank">
                                            <?php echo $copyright_text; ?>
                                        </a>
                                    <?php
                                }
                            ?>
                        </div>
                        <div class="policyWrap">
                            <?php
                                if (!empty($privacy_policy_label)) 
                                {
                                    ?>
                                        <a href="<?php echo $privacy_policy_url; ?>" target="_blank"><?php echo $privacy_policy_label; ?></a>
                                    <?php
                                }
                                if (!empty($terms_of_service_label)) 
                                {
                                    ?>
                                        <a href="<?php echo $terms_of_service_url; ?>" target="_blank"><?php echo $terms_of_service_label; ?></a>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </div>
</div>

    
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/assets/js/vendors.min.js"></script>
<script type="text/javascript">
    var customVariables = {
        baseURL : '',
    };
</script>
<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/assets/js/scripts.min.js"></script>
<script type="text/javascript">
    var ajax_url = "<?php echo admin_url('admin-ajax.php'); ?>";
    var nonce = "<?php echo wp_create_nonce("user_nonce") ?>";

    jQuery(document).ready(function ($)
    {
        $("#submit_btn").click(function (event) {
            event.preventDefault();
            $('.c-err').hide();
            $('.c-success').hide();
            $('.js-contact-form').attr('disabled',true);
            $('.js-contact-form').text('Wait...');

            var first_name = $('#first-name').val();
            var last_name = $('#last-name').val();
            var job_title = $('#job-title').val();
            var email = $('#email').val();
            var number = $('#number').val();
            var country = $('#country option:selected').val();
            var company_name = $('#company-name').val();
            var business = $('#business option:selected').val();
            var employees = $('#employees').val();
            var newsletter = ($('#newsletter').is(":checked")) ? "true" : "false";

            $.ajax(
            {
                type: "POST",
                url: ajax_url,
                data:
                {
                    'action': 'subscription_form',
                    'nonce': nonce,
                    'first_name': first_name,
                    'last_name': last_name,
                    'job_title': job_title,
                    'email': email,
                    'number': number,
                    'country': country,
                    'company_name': company_name,
                    'business': business,
                    'employees': employees,
                    'newsletter': newsletter,
                },

                success: function (result)
                {
                    result = jQuery.parseJSON(result);
                    if (result.status == 1) {
                        $('.js-contact-form').attr('disabled',false);
                        $('.js-contact-form').text('Submit');
                        $('.c-success').html(result.response);
                        $('.c-success').show().delay( 1000 ).fadeOut( 800 );
                        $("#contact-form")[0].reset();
                    }
                    else
                    {
                        $('.c-err').html(result.response);
                        $('.c-err').show().delay( 1000 ).fadeOut( 800 );
                        $('.js-contact-form').attr('disabled',false);
                        $('.js-contact-form').text('Submit');
                    }
                }
            });
            return false;
        });
    });
</script>
</body>

</html>