<?php

define('CONST_SITE_INFORMATION_PAGE_ID', 13);
define('CONTS_ASSETS_VERSION', date("YmdHim"));
define('ALLOW_UNFILTERED_UPLOADS', true );

add_filter('upload_mimes', 'cc_mime_types');
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}

function dd($array)
{
    echo "<pre>";
    print_r($array);
    echo "</pre>";
    die;
}

function json_response($response = array()){
  echo json_encode($response);die;
}

function checkNonce($nonce)
{
    $nonce = checkInputValue($nonce);
    if (wp_verify_nonce( $nonce, "user_nonce")) 
    {
      return true;
    } 
    return false;
}

function checkInputValue($str='')
{
  if($str)
  {
    $str = strip_tags($str);
    $str = addslashes($str);
  }
  return $str;
}


add_action( 'admin_bar_menu', 'add_admin_header_menu_bar', 999 );
function add_admin_header_menu_bar( $wp_admin_bar )
{
    if( current_user_can( 'administrator' ) )
    {

      $menu_args = array(
          'id'    => 'site_info',
          'title' => 'Site Information',
          'href'  => home_url('/wp-admin/post.php?post='.CONST_SITE_INFORMATION_PAGE_ID.'&action=edit'),
          'meta'  => array( 'class' => '' )
      );
      $wp_admin_bar->add_node( $menu_args );
  }
}

function getPostTypeData($post_type,$per_page = -1,$paged='')
{ 
    $arg = array(
      'post_type' => $post_type,
      'order' => 'DESC',
      'posts_per_page' => $per_page,
      'paged' =>  $paged,
      'orderby' => 'publish_date',
    );
    $postData = new WP_Query($arg);
    return $postData;
}

//Service Post Type
// add_action( 'init', 'creatPosttype' );
// function creatPosttype()
// {
//     register_post_type( 'service',
//         array(
//             'labels' => array(
//                 'name' => __('Services'),
//                 'singular_name' => __('Service')
//             ),
//             'public' => true,
//             'has_archive' => false,
//             'show_in_rest' => true,
//             'rewrite' => array('slug' => 'service'),
//             'taxonomies' => array('category'),
//         )
//     );
// }

// Subscription Form
add_action("wp_ajax_subscription_form", "subscriptionForm");
add_action("wp_ajax_nopriv_subscription_form", "subscriptionForm");

function subscriptionForm()
{
  if(isset($_POST['nonce'])) 
  {
    $checkNonce = checkNonce($_POST['nonce']);
    if ($checkNonce == false) 
    {
        json_response(array('status' =>0 ,'response'=>'Invalid Token' ));
    }

  }

  if (
        empty($_POST['first_name']) || 
        empty($_POST['last_name']) || 
        empty($_POST['job_title']) || 
        empty($_POST['email']) || 
        empty($_POST['number']) || 
        empty($_POST['country']) || 
        empty($_POST['company_name']) || 
        empty($_POST['business']) || 
        empty($_POST['employees'])
      )
  {
    json_response(array('status' => 0, 'response' => 'All Fields are Required'));
  }
  if ($_POST['newsletter'] == "false")
  {
    json_response(array('status' => 0, 'response' => 'To proceed, please check the box indicating your consent to receive communications from well@work.'));
  }
  $email_pattern = '/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/';
  if (!preg_match($email_pattern, $_POST['email']))
  {
    json_response(array('status'=> 0,'response' => 'Invalid Email Address'));
  }
  else
  {
    $data = array();
    $data['first_name'] = $_POST['first_name'];
    $data['last_name'] = $_POST['last_name'];
    $data['job_title'] = $_POST['job_title'];
    $data['email'] = $_POST['email'];
    $data['number'] = $_POST['number'];
    $data['country'] = $_POST['country'];
    $data['company_name'] = $_POST['company_name'];
    $data['business'] = $_POST['business'];
    $data['employees'] = $_POST['employees'];
    $data['newsletter'] = $_POST['newsletter'];
    $data['created_at']    = date('Y-m-d H:i:s');
    // dd($data);
    global $wpdb;
    $insert = $wpdb->insert( 'subscription_entries', $data);
    //Email
    if (isset($insert)) 
    {
      $email_message .= 'First Name' . " : ".$data['first_name'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Last Name' . " : ".$data['last_name'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Job Title' . " : ".$data['job_title'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Work Email' . " : ".$data['email'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Phone Number' . " : ".$data['number'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Country' . " : ".$data['country'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Company Name' . " : ".$data['company_name'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Business Type' . " : ".$data['business'];
      $email_message .= "<br>";
      $email_message .= "<br>";
      $email_message .= 'Number Of Employees' . " : ".$data['employees'];
      $email_message .= "<br>";
      $email_message .= "<br> Thank you for subscribing!.";

      $to = $data['email'];
      $subject = 'Subscribe To Our Blog';
      $body = $email_message;
      $headers[] = 'Content-Type: text/html; charset=UTF-8';
      $headers[] = 'From: Well at Work <info@adss-tech.com>';

      $send = wp_mail( $to, $subject, $body, $headers );


      if ($send) 
      {   
        //Send Email to Admin
        $headers   = array();
        $headers[] = 'Content-Type: text/html; charset=UTF-8';
        $headers[] = 'From: Well at Work <info@adss-tech.com>';
        $send = wp_mail( get_field('admin_email',CONST_SITE_INFORMATION_PAGE_ID), "Subscribe To Our Blog", $body, $headers );
        if ($send) 
        {
          json_response(array('status' =>1 ,'response'=>'Success! Email Sent.'));
        }
        else
        {
          json_response(array('status' =>0 ,'response'=>'Fail! Email Not Sent'));
        }
      }
      else
      {
        json_response(array('status' =>0 ,'response'=>'Email Not Sent'));
      }
      //json_response(array('status' =>1 ,'response'=>'Email Sent Successfully'));
    }

    json_response(array('status' =>1 ,'response'=>'Success! You are now subscribed.', 'data' => $data));
  }
}

?>